/**
 * \file: mspin_lm_adapter.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * MySpin LayerManager Adapter
 *
 * \component: MSPIN
 *
 * \author: Torsten Plate BOST/PJ-ES tplate@bosch-softtec.com
 *
 * \copyright: (c) 2015 Bosch SoftTec
 *
 * \history
 * 0.1 TPlate Initial version
 *
 ***********************************************************************/
#ifndef MSPIN_LM_ADAPTER_H_
#define MSPIN_LM_ADAPTER_H_

/***********************************************************************/
/***********                 DO NOT MODIFY!                 ************/
/***********************************************************************/

#ifdef  __cplusplus
extern "C"
{
#endif

#include "mspin_lm_adapter_typedef.h"

/**
 * @func mspin_lm_init
 *
 * Call this function to do the very basic initialization. Call this once before calling any other function.
 * This function is basically called only once per life-cycle.
 *
 * @return Return MSPIN_SUCCESS if everything is ok. Otherwise return an error code.
 */
MSPIN_ERROR mspin_lm_init(void);

/**
 * @func mspin_lm_shutdown
 *
 * This is the opposite of mspin_lm_init(). Cleanup everything here.
 */
void mspin_lm_shutdown(void);

/**
 * @brief mspin_lm_createContext
 *
 * Create the dynamic context of LayerManager adapter. Internal variables of LayerManager adapter can be stored using
 * mspin_layerManager_context (store them in pLMContext->pWLCtx. mspin_layerManager_context has to be defined within
 * the implementation of the LayerManager adapter and is implementation dependent).
 * Please create here the frame buffer for displaying mySPIN data.
 * This function is called dynamically from mySPIN Target Adapter. It is called at minimum once per device connect.
 *
 * When this function is successful, it must set 'readyToUse' of mspin_layerManager_context_t to TRUE.
 *
 * @param pLMContext The LayerManager context. The context will be created by mySPIN Target Adapter and filled with the
 * data required by LayerManager adapter like pixel format and frame size (see definition of mspin_layerManager_context)
 * @param pCoreInstance The mySPIN IVI Core instance which has to be stored by LayerManager adapter for later usage.
 *                      This is needed when the LayerManager adapter has to forward for example touch events to the IVI Core
 * @return Return MSPIN_SUCCESS if everything is OK otherwise an error.
 */
MSPIN_ERROR mspin_lm_createContext(mspin_layerManager_context_t *pLMContext, void *pCoreInstance);

/**
 * @brief mspin_lm_deleteContext
 *
 * The opposite of mspin_lm_createContext(). Delete all dynamically created objects required by LayerManager adapter
 * especially everything under pLMContext->pWLCtx and delete the memory used by it.
 *
 * @param pLMContext The LayerManager context
 */
void mspin_lm_deleteContext(mspin_layerManager_context_t *pLMContext);

/**
 * @brief mspin_lm_pumpEvents
 *
 * This function gives the LayerManager adapter the possibility to do period things like checking for touch events.
 * Please take care that this function is not longer blocking than the set timeout (which is typically between 20 to
 * 100 ms).
 *
 * @param pLMContext The LayerManager context
 * @param timeout The timeout which defines the maximum time this function may block
 */
void mspin_lm_pumpEvents(mspin_layerManager_context_t *pLMContext, S32 timeout);

/**
 * @brief mspin_lm_copyRect
 *
 * Copies the specified rectangle at the given position to the frame buffer. Normally this is the complete frame but
 * it can also be a partial update. Several partial updates are allowed for one frame update. In case of partial updates
 * make sure that the data is copied to the correct area (e.g. line by line).
 *
 * @param pLMContext The LayerManager context
 * @param currentNumber The number of updates
 * @param x0 The x position of the rectangle relative to the frame size
 * @param y0 The y position of the rectangle relative to the frame size
 * @param width The width of the rectangle to copy
 * @param height The height of the rectangle to copy
 * @param pBuffer The pointer to the buffer with the frame data
 * @param bufferSize The size of the buffer
 */
void mspin_lm_copyRect(mspin_layerManager_context_t *pLMContext, U8 currentNumber, U16 x0, U16 y0,
        U16 width, U16 height, U8 *pBuffer, U32 bufferSize);

/**
 * @brief mspin_lm_drawFrame
 *
 * Display now the frame which was copied earlier by mspin_lm_copyRect(...) to the frame buffer.
 *
 * @param pLMContext The LayerManager context
 */
void mspin_lm_drawFrame(mspin_layerManager_context_t *pLMContext);

#ifdef __cplusplus
}
#endif

#endif /* MSPIN_LM_ADAPTER_H_ */
